﻿Start-Transcript -Path "$env:TEMP\redbox-upsinstall.log" -Append

#region Functions
Function Start-Installation
{
    param
    (
        [Parameter(Position=0,Mandatory=$true)]
        [System.String]$Exe,
        [Parameter(Position=1)]
        [System.String]$Args
    )    
    $CmdLineArgs=@("/C","`"$Exe`"")
    if(-not [System.String]::IsNullOrEmpty($Args))
    {
        $CmdLineArgs+=$Args
    }
    Start-Process -FilePath "$env:windir\System32\cmd.exe" -ArgumentList $CmdLineArgs -Wait
}
#endregion

#region Initialization
$CurrentDirectory=[System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Definition)
$IsPresent=$false
#endregion

#region UPS Software Installations

$TrippLiteHWID="HID\\VID_09AE"
$APCHWID="HID\\VID_051D"

$TrippLiteSetup="TrippLite\install.cmd"
$PowerChuteSetup="Powerchute\setup.exe"

$TrippLiteArgs=""
$PowerChuteArgs="-s"

#endregion

#region Detection and Installation

#We try to find the TrippLite device first
$wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$TrippLiteHWID%'"
$PnpDevices=Get-WmiObject -Query $wql
foreach ($PnpDevice in $PnpDevices)
{
    if($PnpDevice -ne $null)
    {
        $IsPresent=$true
        Write-Host "Found TrippLite UPS $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)"
        $ExePath=Join-Path $CurrentDirectory $TrippLiteSetup
        #Fire Off The Installation
        Start-Installation -Exe $ExePath -Args $TrippLiteArgs
        break
    }
}

#So...No TrippLite is present...
if(-not $IsPresent)
{
    #Next we look for the APC device...
    $wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$APCHWID%'"
    $PnpDevices=Get-WmiObject -Query $wql
    foreach ($PnpDevice in $PnpDevices)
    {
        if($PnpDevice -ne $null)
        {
            Write-Host "Found TrippLite UPS $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)"
            $ExePath=Join-Path $CurrentDirectory $PowerChuteSetup
            #Fire Off The Installation
            Start-Installation -Exe $ExePath -Args $PowerChuteArgs
            break            
        }
    }
}

#endregion

Write-Host "Complete!"
Stop-Transcript|Out-Null